;---------------------------------------------------
;  _____  _____ _   _    ______                      _____ _             _ _         ___
; |_   _|/ ____| \ | |  |  ____|                    / ____| |           | (_)       |__ \
;   | | | (___ |  \| |  | |__ ___  _ __ _ __ ___   | (___ | |_ _   _  __| |_  ___      ) |
;   | |  \___ \| . ` |  |  __/ _ \| '__| '_ ` _ \   \___ \| __| | | |/ _` | |/ _ \    / /
;  _| |_ ____) | |\  |  | | | (_) | |  | | | | | |  ____) | |_| |_| | (_| | | (_) |  / /_
; |_____|_____/|_| \_|  |_|  \___/|_|  |_| |_| |_| |_____/ \__|\__,_|\__,_|_|\___/  |____|
;
; by ISI360 (Christian Faderl)
;---------------------------------------------------

;Autoit Wrapper settings
#AutoIt3Wrapper_Res_Fileversion=2.81
#AutoIt3Wrapper_Res_ProductVersion=2.81
#AutoIt3Wrapper_Res_LegalCopyright=ISI360
#AutoIt3Wrapper_Res_Description=ISN Form Studio 2 Plugin
#AutoIt3Wrapper_Res_requestedExecutionLevel=asInvoker
#AutoIt3Wrapper_Res_Field=ProductName|ISN Form Studio 2
#AutoIt3Wrapper_UseX64=n
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_Res_HiDpi=Y
#AutoIt3Wrapper_Outfile_type=a3x

;Set Res_HiDpi, if not compiled
if not @Compiled then DllCall("User32.dll","bool","SetProcessDPIAware")

;Version stuff
Global $Programmversion = "Version 2.81"
Global $DEBUG = "false" ;Falls das FormStudio ohne ISN getestet wird (Formstudio kann mit ESC geschlossen werden)

;AutoIt Options
Opt("GUIResizeMode", 802)
Opt("GUIOnEventMode", 1)
Opt("MouseCoordMode", 2)
Opt("GUICoordMode", 1)
Opt("GUICloseOnESC", 0)
If $DEBUG = "true" Then
	Opt("GUICloseOnESC", 1)
	OnAutoItExitRegister("_exit")
EndIf

;Formstudio must started with a file as parameter
If $DEBUG <> "true" Then
	#NoTrayIcon
	If $CmdLine[0] = 0 Then
		MsgBox(16, "Fehler (Error)", "Dieses Programm ist Teil des ISN AutoIt Studios und kann nicht alleine gestartet werden!" & @CRLF & @CRLF & "This program is part of the ISN AutoIt Studio and cannot be started separately!")
		Exit
	EndIf
	Global $Filetoopen = $CmdLine[1]
EndIf


If $DEBUG = "true" Then Global $Filetoopen = "C:\Users\" & @UserName & "\Google Drive\ISN AutoIt Studio\Projects\Testprojekt 22\forms\was.isf"

;Check, if file exists
If Not FileExists($Filetoopen) Then
	MsgBox(16, "Error", "Cannot open file!" & @CRLF & @CRLF & $Filetoopen & @CRLF & @CRLF & "Form Studio 2 will exit now!")
	Exit
 EndIf


; Includes 1/2
#include "..\PLUGIN SDK\isnautoitstudio_plugin.au3"
#include <GuiStatusBar.au3>
#include "includes\IniEx.au3"
#include "includes\USkin.au3"
#include <WindowsConstants.au3>
#include <WinAPI.au3>
#include <WinAPISysWin.au3>
#include <GUIConstantsEx.au3>


If $DEBUG = "true" Then
   Global $StudioFenster = GUICreate("ISN Form Studio 2", @DesktopWidth - 200, @DesktopHeight - 200, -1, -1,$WS_SIZEBOX+$WS_MINIMIZEBOX+ $WS_CAPTION+ $WS_POPUP+$WS_SYSMENU+$WS_MAXIMIZEBOX, $WS_EX_CLIENTEDGE)
Else
   Global $StudioFenster = GUICreate("ISN Form Studio 2", @DesktopWidth - 200, @DesktopHeight - 200, -1, -1,$WS_POPUP, $WS_EX_CLIENTEDGE+$WS_EX_TOOLWINDOW)
Endif

_WinAPI_SetClassLongEx($StudioFenster, $GCL_STYLE, BitAND(_WinAPI_GetClassLongEx($StudioFenster, $GCL_STYLE), BitNOT(1), BitNOT(2))) ;unset CS_HREDRAW and CS_VREDRAW flags. Prevent flickering on resite. thx to binhnx!

;Plugin initialization
If $DEBUG <> "true" Then
   _ISNPlugin_initialize($StudioFenster)
   If @error Then
	   MsgBox(16, "Error", "This program is part of the ISN AutoIt Studio and cannot be started separately!")
	   Exit ;Plugin can not start without the ISN
   EndIf
EndIf


#include "includes\deklarationen.au3"
If $DEBUG <> "true" Then _WinAPI_SetWindowPos($StudioFenster, $HWND_TOPMOST, 9000, 9000, @DesktopWidth - 200, @DesktopHeight - 200, $SWP_SHOWWINDOW)
GUISwitch($StudioFenster)
GUISetFont($Default_font_size, 400, 0, $Default_font, $StudioFenster)
If $ISN_Dark_Mode = "true" Then GUISetBkColor($GUI_Farbe, $StudioFenster)



;Skin auch im Plugin Anwenden
_Uskin_LoadDLL($ISN_AutoIt_Studio_EXE_Path & "\Data\USkin.dll")
If $Use_ISN_Skin = "true" Then
	If Not FileExists(_PathFull($ISN_AutoIt_Studio_EXE_Path & "\Data\Skins\" & $Current_ISN_Skin)) Then $Current_ISN_Skin = "#none#"
	$pfad = _PathFull($ISN_AutoIt_Studio_EXE_Path & "\Data\Skins\" & $Current_ISN_Skin & "\skin.msstyles")
	If $Current_ISN_Skin <> "#none#" Then
	    $Skin_is_used = true
		_USkin_Init($pfad) ;skin zuweisen
	EndIf
EndIf




;Includes 2/2
#include "includes\DPI_Scaling.au3"
#include <Constants.au3>
#include <String.au3>
#include <GuiEdit.au3>
#include <EditConstants.au3>
#include <StaticConstants.au3>
#include "includes\scintilla.h.au3"
#include <GuiToolbar.au3>
#include <GuiImageList.au3>
#include <StructureConstants.au3>
#include <Misc.au3>
#include <ProgressConstants.au3>
#include <ButtonConstants.au3>
#include <GuiToolTip.au3>
#include <Color.au3>
#include <GuiComboBox.au3>
#include <WinAPILocale.au3>
#include <ScrollBarConstants.au3>
#include <GuiSlider.au3>
#include <TreeViewConstants.au3>
#include <GuiTreeView.au3>
#include <GuiListView.au3>
#include <file.au3>
#include <ClipBoard.au3>
#include <TabConstants.au3>
#include <GuiListBox.au3>
#include <ComboConstants.au3>
#include <GuiTab.au3>
#include <DateTimeConstants.au3>
#include <GuiRichEdit.au3>
#include <GuiMenu.au3>
#include <GDIPlus.au3>
#include <Timers.au3>
#include <Math.au3>
#include <ListboxConstants.au3>
#include <GuiIPAddress.au3>
#include <UpdownConstants.au3>
#include "includes\GUIScrollbars_Ex.au3"
#include "includes\GUIListViewEx.au3"
#include "includes\Icons.au3"




Global $hToolTip = _GUIToolTip_Create($StudioFenster) ;Globaler Tooltip Handler
sleep(200)
$winsize = WinGetClientSize($StudioFenster)
$winpos = WinGetPos($StudioFenster)
$FormStudioStartup_Logo = GUICtrlCreatePic("", ($winsize[0] / 2) - ((300 * $DPI) / 2), ($winsize[1] / 2) - ((89 * $DPI) / 2), 300 * $DPI, 89 * $DPI)
GUICtrlSetState($FormStudioStartup_Logo, $GUI_DISABLE)
_SetImage($FormStudioStartup_Logo, @ScriptDir & "\data\logo.png")
_SendMessage($StudioFenster, $WM_SETREDRAW, False) ;Lock GUI for faster startup

$Side1_PIC = GUICtrlCreatePic(@ScriptDir & "\data\side.jpg", 0, 0, 178 * $DPI, @DesktopHeight)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetState(-1, $GUI_DISABLE)
If $ISN_Dark_Mode = "true" Then GUICtrlSetImage($Side1_PIC, "")

$blue_1 = GUICtrlCreatePic(@ScriptDir & "\data\blue.jpg", 178 * $DPI, 0, 6 * $DPI, @DesktopHeight)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetState(-1, $GUI_DISABLE)
If $ISN_Dark_Mode = "true" Then GUICtrlSetImage($blue_1, @ScriptDir & "\data\grey.jpg")
$pos = ControlGetPos($StudioFenster, "", $blue_1)


; Add Icons from system DLL shell32.dll to ImageList
$hToolBarImageListNorm = _GUIImageList_Create(16, 16, 5, 3)
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1794) ;button
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1813) ;label
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 795) ;input
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1360) ;checkbox
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1174) ;radio
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1818) ;image
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1824) ;slider
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1819) ;progress
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1163) ;updown
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1081) ;icon
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1798) ;combo
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 91) ;edit & richedit
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1809) ;group
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1814) ;listbox
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1077) ;tab
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1802) ;date
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1795) ;calendar
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1815) ;listview
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1189) ;softbutton
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1432) ;ip
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1716) ;treeview
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1915) ;menu
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1176) ;com object
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 590) ;dummy
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 471) ;graphic
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1919) ;toolbar
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1920) ;statusbar
_GUIImageList_AddIcon($hToolBarImageListNorm, $smallIconsdll, 1787) ;Extracode

;Add Controls in Toolbox
If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_SaveButton = GUICtrlCreatePic("", 5, 5, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 1301 + 1, 16, 16)
Else
	$Formstudio_SaveButton = GUICtrlCreateButton("", 5, 5, 25, 24) ;Save
	Button_AddIcon(-1, $smallIconsdll, 1301, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(84)&" (Ctrl + S)")
GUICtrlSetOnEvent(-1, "_Speichern")
GUICtrlSetState(-1,$GUI_DISABLE)
GUICtrlSetResizing(-1, $GUI_DOCKALL)

If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_TestFormButton = GUICtrlCreatePic("", 5, 30, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 220 + 1, 16, 16)
Else
	$Formstudio_TestFormButton = GUICtrlCreateButton("", 5, 30, 25, 24) ;Test form
	Button_AddIcon(-1, $smallIconsdll, 220, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(85))
GUICtrlSetOnEvent(-1, "_test_code")
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetState(-1,$GUI_DISABLE)


If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_GenerateCodeButton = GUICtrlCreatePic("", 32, 30, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $ISN_AutoIt_Studio_EXE_Path & "\autoitstudioicon.ico", 0, 16, 16)
Else
	$Formstudio_GenerateCodeButton = GUICtrlCreateButton("", 32, 30, 25, 24) ;Code
	Button_AddIcon(-1, $ISN_AutoIt_Studio_EXE_Path & "\autoitstudioicon.ico", 0, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(86))
GUICtrlSetOnEvent(-1, "_Code_Generieren")
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetState(-1,$GUI_DISABLE)

If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_FormPropertiesButton = GUICtrlCreatePic("", 59, 30, 24, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 780 + 1, 16, 16)
Else
	$Formstudio_FormPropertiesButton = GUICtrlCreateButton("", 59, 30, 24, 24) ;GUI eigenschaft
	Button_AddIcon(-1, $smallIconsdll, 780, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(87))
GUICtrlSetOnEvent(-1, "_Show_Edit_Form")
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetState(-1,$GUI_DISABLE)

If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_ControlsOrderButton = GUICtrlCreatePic("", 86, 30, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 479 + 1, 16, 16)
Else
	$Formstudio_ControlsOrderButton = GUICtrlCreateButton("", 86, 30, 25, 24) ;Reihenfolge der Controls
	Button_AddIcon(-1, $smallIconsdll, 479, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(175))
GUICtrlSetOnEvent(-1, "_Zeige_Control_Reihenfolge_GUI")
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetState(-1,$GUI_DISABLE)

If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_SettingsButton = GUICtrlCreatePic("", 113, 30, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 1082 + 1, 16, 16)
Else
	$Formstudio_SettingsButton = GUICtrlCreateButton("", 113, 30, 25, 24) ;setup
	Button_AddIcon(-1, $smallIconsdll, 1082, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(119))
GUICtrlSetOnEvent(-1, "_Show_Setup")
GUICtrlSetResizing(-1, $GUI_DOCKALL)



If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_UndoButton = GUICtrlCreatePic("", 32, 5, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 727 + 1, 16, 16)
Else
	$Formstudio_UndoButton = GUICtrlCreateButton("", 32, 5, 25, 24) ;Undo
	Button_AddIcon(-1, $smallIconsdll, 727, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(264)&" (Ctrl + Z)")
GUICtrlSetOnEvent(-1, "_Formstudio_Undo")
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetState(-1,$GUI_DISABLE)

If $Current_ISN_Skin <> "#none#" And $Use_ISN_Skin = "true" Then
	$Formstudio_RedoButton = GUICtrlCreatePic("", 59, 5, 25, 24, $SS_NOTIFY + $SS_CENTERIMAGE, $WS_EX_CLIENTEDGE)
	_SetIconAlpha(-1, $smallIconsdll, 193 + 1, 16, 16)
Else
	$Formstudio_RedoButton = GUICtrlCreateButton("", 59, 5, 25, 24) ;Redo
	Button_AddIcon(-1, $smallIconsdll, 193, 4)
EndIf
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
_Control_Add_ToolTip(-1, _ISNPlugin_Get_langstring(265)&" (Ctrl + Y)")
GUICtrlSetOnEvent(-1, "_Formstudio_Redo")
GUICtrlSetResizing(-1, $GUI_DOCKALL)
GUICtrlSetState(-1,$GUI_DISABLE)


$FormStudioSidebarSep = GUICtrlCreateGroup("", 5, 53, 170, 10) ;Sep
GUICtrlSetState(-1,$GUI_HIDE)
_Control_set_DPI_Scaling(-1)
GUICtrlSetResizing(-1, $GUI_DOCKALL)











$FormStudioSideBar_Logo = GUICtrlCreatePic("", 3 * $DPI, 5 * $DPI, 170 * $DPI, 50 * $DPI)
GUICtrlSetState($FormStudioSideBar_Logo, $GUI_DISABLE)
GUICtrlSetState($FormStudioSideBar_Logo, $GUI_HIDE)
_SetImage($FormStudioSideBar_Logo, @ScriptDir & "\data\logo.png")

$Toolbox_listview = GUICtrlCreateListView("", 5 * $DPI, 70 * $DPI,170 * $DPI, $winsize[1]-(70 * $DPI)-(2 * $DPI), BitOR($LVS_SHOWSELALWAYS, $LVS_SINGLESEL, $LVS_NOCOLUMNHEADER))
GUICtrlSetState($Toolbox_listview, $GUI_HIDE)
;~ GUICtrlSetResizing(-1, $GUI_DOCKLEFT+$GUI_DOCKTOP+$GUI_DOCKWIDTH+$GUI_DOCKBOTTOM)
_GUICtrlListView_SetExtendedListViewStyle($Toolbox_listview, BitOR($LVS_EX_FULLROWSELECT, $LVS_EX_SUBITEMIMAGES), $LVS_EX_UNDERLINEHOT)
_GUICtrlListView_InsertColumn($Toolbox_listview, 0, "", 145 * $DPI)

If $ISN_Dark_Mode = "true" Then
	GUICtrlSetBkColor($Toolbox_listview, $Toolbox_Farbe)
	GUICtrlSetColor($Toolbox_listview, 0xFFFFFF)
EndIf


If _ist_windows_vista_oder_hoeher() And $ISN_Dark_Mode <> "true" Then _GUICtrlListView_EnableGroupView($Toolbox_listview) ;Groupview nur ab win Vista
_GUICtrlListView_SetImageList($Toolbox_listview, $hToolBarImageListNorm, 1)
_GUICtrlListView_JustifyColumn($Toolbox_listview, 0, 2)
_GUICtrlListView_InsertGroup($Toolbox_listview, -1, 0, "") ;Standard
_GUICtrlListView_SetGroupInfo($Toolbox_listview, 0, _ISNPlugin_Get_langstring(21), 1, $LVGS_COLLAPSIBLE)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(22), 0) ;button
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 0, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(23), 1) ;label
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 1, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(24), 2) ;input
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 2, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(25), 3) ;checkbox
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 3, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(26), 4) ;radio
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 4, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(27), 5) ;image
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 5, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(28), 6) ;slider
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 6, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(29), 7) ;progress
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 7, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(31), 8) ;updown
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 8, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(32), 9) ;icon
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 9, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(33), 10) ;combo
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 10, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(34), 11) ;edit
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 11, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(35), 12) ;group
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 12, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(36), 13) ;listbox
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 13, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(138), 20) ;treeview
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 14, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(232), 23) ;dummy
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 15, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(246), 24) ;Graphic
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 16, 0)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(258), 26) ;Statusbar
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 17, 0)



_GUICtrlListView_InsertGroup($Toolbox_listview, -1, 1, "")
_GUICtrlListView_SetGroupInfo($Toolbox_listview, 1, _ISNPlugin_Get_langstring(37), 1, $LVGS_COLLAPSIBLE) ;Erweiterte

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(38), 14) ;tab
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 18, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(39), 15) ;date
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 19, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(40), 16) ;calendar
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 20, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(41), 17) ;listview
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 21, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(124), 18) ;softbutton
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 22, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(192), 21) ;Menu
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 23, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(136), 19) ;ip
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 24, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(214), 22) ;COM-Object
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 25, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(252), 25) ;Toolbar
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 26, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(266), 11) ;RichEdit
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 27, 1)

_GUICtrlListView_AddItem($Toolbox_listview, _ISNPlugin_Get_langstring(267), 27) ;Extracode Element
_GUICtrlListView_SetItemGroupID($Toolbox_listview, 28, 1)

_SendMessage($StudioFenster, $WM_SETREDRAW, True) ;Unlock GUI
_WinAPI_RedrawWindow($StudioFenster)

GUISetOnEvent($GUI_EVENT_CLOSE, "_exit", $StudioFenster)
$size = WinGetPos($StudioFenster)
GUISetState(@SW_SHOWNOACTIVATE, $StudioFenster)
GUISetState(@SW_DISABLE, $GUI_Editor)
GUISetState(@SW_DISABLE, $StudioFenster)


$Groesse_studioFenster = WinGetClientSize($StudioFenster)
$Loading1_Ani = _ISNPlugin_Get_Variable_From_ISN_AutoIt_Studio("$Loading1_Ani")


$StudioFensterInsideXStartpos = (178 * $DPI) + (6 * $DPI) - $FormStudio_GuiBorderWidth
$StudioFensterInsideYStartpos = 0 - $FormStudio_GuiTitleHeight - $FormStudio_GuiBorderWidth
$StudioFensterInsideWidth = ($winsize[0] - $StudioFensterInsideXStartpos) + $FormStudio_GuiBorderWidth
$StudioFensterInsideHeight = $winsize[1] + $FormStudio_GuiTitleHeight + ($FormStudio_GuiBorderWidth * 2)




$StudioFenster_inside = GUICreate("inside", 800, 600, 0, 0, BitOR($WS_CAPTION, $WS_CHILD),-1, $StudioFenster)
_SendMessage($StudioFenster_inside, $WM_SETREDRAW, False)
;Create a pattern of the background background image
$BGImageFile = @ScriptDir & "\data\background.jpg"
If $ISN_Dark_Mode = "true" Then $BGImageFile = @ScriptDir & "\data\background_dark.jpg"
_FormStudioCreateBackgroundPattern($StudioFenster_inside,  $BGImageFile, 4)
;~ GUICtrlCreateInput("", -7000, 12, 212, 26, -1, -1) ;Dummy, sonst funktioniert das scrolling nicht!
$Groesse_studioFenster_inside = WinGetClientSize($StudioFenster_inside, "")
;~ GUISetBkColor(0xFFFFF0, $StudioFenster_inside)
If IsArray($winpos) And IsArray($pos) Then _WinAPI_SetWindowPos($StudioFenster_inside, $HWND_TOP, $StudioFensterInsideXStartpos, $StudioFensterInsideYStartpos, $StudioFensterInsideWidth, $StudioFensterInsideHeight, $SWP_SHOWWINDOW)
;~ _WinAPI_SetLayeredWindowAttributes($StudioFenster_inside, 0xFFFFF0, 255)
$StudioFenster_inside_Text1 = GUICtrlCreateLabel(_ISNPlugin_Get_langstring(51), 75 * $DPI, 12 * $DPI, 212 * $DPI, 26 * $DPI, -1, -1)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetFont(-1, 12, 700, Default, $Default_font)
If $ISN_Dark_Mode = "true" Then GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, "-2")
$StudioFenster_inside_Icon = GUICtrlCreateIcon($Loading1_Ani, -1, 20 * $DPI, 13 * $DPI, 32, 32)
GUICtrlSetState(-1, $GUI_HIDE)
$StudioFenster_inside_load = GUICtrlCreateProgress(0, 0, 283 * $DPI, 10 * $DPI, -1, -1)
GUICtrlSetState(-1, $GUI_HIDE)
$StudioFenster_inside_Text2 = GUICtrlCreateLabel("", 75 * $DPI, 12 * $DPI, 212 * $DPI, 26 * $DPI, $SS_CENTER, -1)
GUICtrlSetFont(-1, 12, 400, Default, $Default_font)
If $ISN_Dark_Mode = "true" Then GUICtrlSetColor(-1, 0xFFFFFF)
GUICtrlSetBkColor(-1, "-2")
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetState($Side1_PIC,$GUI_SHOW)
GUICtrlSetState($blue_1,$GUI_SHOW)
_SendMessage($StudioFenster_inside, $WM_SETREDRAW, True)

;_FormStudio_CutGuiBorders($StudioFenster_inside)
_SendMessage($StudioFenster, $WM_SETREDRAW, False) ;Unlock GUI
_GUIScrollbars_Generate($StudioFenster_inside, 3000, 3000)
_GUIScrollBars_ShowScrollBar($StudioFenster_inside, $SB_BOTH, False)
_SendMessage($StudioFenster, $WM_SETREDRAW, True) ;Unlock GUI
_WinAPI_RedrawWindow($StudioFenster)

;Die restlichen Includes
#include "includes\Forms.au3"
#include "includes\Addons2.au3"
#include "includes\Addons3.au3"
#include "includes\Addons.au3"
#include "includes\converter.au3"
#include "includes\menueditor.au3"



$FormStudio_UndoRedoScintillaGUI = GUICreate("Formstudio - LiveCache",800* $DPI,600* $DPI)
$hLib = LoadLibrary(@ScriptDir & "\data\SciLexer.DLL")
Global $FormStudio_UndoRedoScintilla = CreateWindowEx($WS_EX_CLIENTEDGE, "Scintilla", "TEST", BitOR($WS_CHILD, $WS_VISIBLE, $WS_HSCROLL, $WS_VSCROLL, $WS_TABSTOP, $WS_CLIPCHILDREN), 0, 0, 800* $DPI, 600* $DPI, $FormStudio_UndoRedoScintillaGUI, 0, 0, 0)
If _System_benoetigt_double_byte_character_Support() Then
  SendMessage($FormStudio_UndoRedoScintilla, $SCI_SETCODEPAGE, 936, 0) ;Setzte China Encoding für Scintila 936 (Simplified Chinese)
Else
  SendMessage($FormStudio_UndoRedoScintilla, $SCI_SETCODEPAGE, $SC_CP_UTF8, 0)
EndIf
;~ GUISetState(@SW_SHOW,$FormStudio_UndoRedoScintillaGUI)



_SetStatustext(_ISNPlugin_Get_langstring(46))
Create_Default_Cache()
$iLastTab1 = 0 ;starttab von editforms

_Minieditor_tab_select(-1)
_Minieditor_tab_select(0)
_Form_bearbeitenGUI_tab_select(0)
_Elemente_an_Fesntergroesse_anpassen()


;~ $GUI_Editor = GUICreate("Form1", 640, 480, 10, 10, BitOR($WS_CAPTION, $WS_POPUP, $WS_SIZEBOX), -1,$Studiofenster) ;Dummygui die wieder gelöscht wird

If $Draw_grid_in_gui = "1" Then _DrawGrid($Raster, $Grid_Farbe)


GUISetState(@SW_SHOWNOACTIVATE, $StudioFenster_inside)
_resize_elements()


GUICtrlSetState($FormStudioStartup_Logo, $GUI_HIDE)
_Load_from_file($Filetoopen) ;Lade die .isf Datei



SCI_SetTextEx($FormStudio_UndoRedoScintilla,_Formstudio_GetCacheContent($Cache_Datei_Handle))
SendMessage($FormStudio_UndoRedoScintilla, $SCI_EMPTYUNDOBUFFER, 0, 0)
_GUIScrollBars_ShowScrollBar($StudioFenster_inside, $SB_BOTH, True)
GUICtrlSetState($Toolbox_listview, $GUI_SHOW)
GUICtrlSetState($FormStudioSideBar_Logo, $GUI_SHOW)
GUICtrlSetState($FormStudioSidebarSep,$GUI_SHOW)
GUICtrlSetState($Formstudio_RedoButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_UndoButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_SettingsButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_ControlsOrderButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_FormPropertiesButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_GenerateCodeButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_TestFormButton,$GUI_SHOW)
GUICtrlSetState($Formstudio_SaveButton,$GUI_SHOW)



$AutoITEXE_Path = _ISN_Variablen_aufloesen($AutoITEXE_Path)




GUISetState(@SW_ENABLE, $GUI_Editor)
GUISetState(@SW_ENABLE, $StudioFenster)
GUISetState(@SW_ENABLE, $StudioFenster_inside)
GUISetState(@SW_ENABLE, $Formstudio_controleditor_GUI)


;Registriere Windows Messages
GUIRegisterMsg($WM_CONTEXTMENU, "WM_CONTEXTMENU")
GUIRegisterMsg($WM_COMMAND, "WM_COMMAND")
GUIRegisterMsg($WM_MOUSEWHEEL, "_Mousewheel")

GUIRegisterMsg($WM_SIZE, "WM_SIZE")
GUIRegisterMsg($WM_EXITSIZEMOVE, "WM_EXITSIZEMOVE")
GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
GUIRegisterMsg($WM_GETMINMAXINFO, "WM_GETMINMAXINFO")
GUIRegisterMsg($WM_MOUSEMOVE, "_GUIListViewEx_WM_MOUSEMOVE_Handler")
GUIRegisterMsg($WM_LBUTTONUP, "_GUIListViewEx_WM_LBUTTONUP_Handler")
GUISetOnEvent($GUI_EVENT_MAXIMIZE,"_resize_elements",$StudioFenster)
GUISetOnEvent($GUI_EVENT_RESTORE,"_resize_elements",$StudioFenster)




;setze Hilfetexte für einige Inputs
_Input_Setze_Hilfetext($MiniEditor_ControlState, _ISNPlugin_Get_langstring(242))
_Input_Setze_Hilfetext($MiniEditor_Style, _ISNPlugin_Get_langstring(242))
_Input_Setze_Hilfetext($MiniEditor_ExStyle, _ISNPlugin_Get_langstring(242))
_Input_Setze_Hilfetext($Form_bearbeitenStyle, _ISNPlugin_Get_langstring(242))
_Input_Setze_Hilfetext($Form_bearbeitenExstyle, _ISNPlugin_Get_langstring(242))


;WinActivate($GUI_Editor)

GUISwitch($GUI_Editor)

GUISetState(@SW_SHOWNOACTIVATE, $Formstudio_controleditor_GUI)
GUISetState(@SW_SHOWNOACTIVATE, $GUI_Editor)
;if not _ist_windows_8_oder_hoeher() then _WinAPI_RedrawWindow($StudioFenster)

;Events für das ISN Registrieren
_ISNPlugin_Register_ISN_Event($ISN_AutoIt_Studio_Event_Exit_Plugin, "_exit")
_ISNPlugin_Register_ISN_Event($ISN_AutoIt_Studio_Event_Save_Command, "_SPEICHERN")
_ISNPlugin_Register_ISN_Event($ISN_AutoIt_Studio_Event_Check_Changes_before_Exit, "_Pruefe_Aenderungen_vor_dem_schliessen")
;~ _ISNPlugin_Register_ISN_Event($ISN_AutoIt_Studio_Event_Resize, "_resize_elements")
;~ _ISNPlugin_Register_ISN_Event($ISN_AutoIt_Studio_Event_Switch_Tab, "_resize_elements")



_Input_Setze_Hilfetext($Form_bearbeitenStyle, _ISNPlugin_Get_langstring(242))
_Input_Setze_Hilfetext($Form_bearbeitenExstyle, _ISNPlugin_Get_langstring(242))




Local $Pos_oldpos
Local $iLastTab1 = 0
While 1

   ;GUIListViewEx Stuff
   $GUIListViewEx_Event = _GUIListViewEx_EventMonitor()
   	Switch @extended
	   Case 4 ;Dragged
		  _FormStudio_GUIListViewEx_RedrawIcons(_GUIListViewEx_GetActive())
	EndSwitch


	$pos_bluecontrol = ControlGetPos($StudioFenster, "", $blue_1)
;~ 	$Studiofenster_State = WinGetState($StudioFenster)
;~ 	If BitAND($Studiofenster_State, 4) Then
;~ 		GUISetState(@SW_ENABLE, $GUI_Editor)
;~ 	Else
;~ 		GUISetState(@SW_DISABLE, $GUI_Editor)
;~ 	EndIf


	$iCurrTab1 = _GUICtrlTab_GetCurFocus($gui_setup_tab)
	; If the Tab has changed
	If $iCurrTab1 <> $iLastTab1 Then
		; Store the value for future comparisons
		; Show/Hide controls as required
		_Form_bearbeitenGUI_tab_select($iCurrTab1, $iLastTab1)
		$iLastTab1 = $iCurrTab1
	EndIf

	$Cursor_INFO = GUIGetCursorInfo($GUI_Editor)

	If _IsPressed("01", $dll) And WinActive($GUI_Editor) And IsArray($Cursor_INFO) Then
		_Pruefe_auf_doppelklick() ;Doppelkick auf Control prüfen
		_WinAPI_SetWindowPos($GUI_Editor, $HWND_TOP, 200, 200, 200, 200, $SWP_NOSIZE + $SWP_NOACTIVATE + $SWP_NOMOVE)
		If $Control_Markiert_MULTI = 1 And _IsPressed("11", $dll) = 0 Then
;~ 				sleep(150)
			If _IsPressed("01", $dll) = 0 Then
				Entferne_Makierung()
			EndIf
		EndIf


;~ ;Erster Check ob es sich nicht doch um zb. ein Combo handelt -> Get Parent vom Edit
		If $Cursor_INFO[4] = "" Then
			$tPoint = _WinAPI_GetMousePos()
			$Clicked_Handle = _WinAPI_GetParent(_WinAPI_WindowFromPoint($tPoint))
			If $Clicked_Handle <> 0 Then
				$Cursor_INFO[4] = _WinAPI_GetDlgCtrlID($Clicked_Handle)
			EndIf
		EndIf

		If $Cursor_INFO[4] = "" Then
			If $Markiertes_Control_ID = "" And $Ziehe_Gerade = 0 Then _Ziehe_Rahmen()
			If _IsPressed("01", $dll) And _Ist_Maus_in_einem_Markierten_control() = False Then
				If $Markiertes_Control_ID <> "" Or $Control_Markiert_MULTI = 1 Then _Mini_Editor_Einstellungen_Uebernehmen()
;~ 			if $Control_Markiert_MULTI = 1 AND _IsPressed("01", $dll) AND _Ist_Maus_in_einem_Markierten_control() = false then
				Entferne_Makierung(1)
				ContinueLoop
			EndIf


		Else

			If _IsPressed("11", $dll) And $Control_Markiert_MULTI = 0 And Not $Markiertes_Control_ID = "" Then _Switch_from_singe_to_multiselection_mode($Cursor_INFO[4])
			If _IsPressed("11", $dll) And $Control_Markiert_MULTI = 1 Then
				_Add_control_to_Multiselection($Cursor_INFO[4])
				ContinueLoop
			EndIf
			If $Control_Markiert_MULTI = 1 And _Ist_Maus_in_einem_Markierten_control() = True Then _DragMe_Multi($Cursor_INFO[4])




			If _IsPressed("11", $dll) = 0 And $Control_Markiert_MULTI = 1 And $Markiertes_Control_ID = "" And _IsPressed("01", $dll) Then Entferne_Makierung(1)
			If $Control_Markiert = 0 Or $Cursor_INFO[4] <> $Markiertes_Control_ID Then

				If $Markiertes_Control_ID <> "" Then _Mini_Editor_Einstellungen_Uebernehmen()


				Markiere_Controls_EDIT($Cursor_INFO[4])
				Sleep(50)

			Else
				_DragMe()
			EndIf
		EndIf
;~ 		if _IsPressed("01", $dll) AND $Cursor_INFO[4] = $BGimage AND $Ziehe_Gerade = 0 then _Ziehe_Rahmen()
;~ 		if _IsPressed("01", $dll) AND $Cursor_INFO[4] = $Grid_Handle AND $Ziehe_Gerade = 0 then _Ziehe_Rahmen()
		If IsHWnd($GUI_Editor) Then

			If _IsPressed("01", $dll) And $Cursor_INFO[4] <> $Markiertes_Control_ID And (_IniReadEx($Cache_Datei_Handle, ControlGetHandle($GUI_Editor, "", $Cursor_INFO[4]), "id", "#error#") = "#error#" Or _IniReadEx($Cache_Datei_Handle, ControlGetHandle($GUI_Editor, "", $Cursor_INFO[4]), "id", "#error#") = "") And $Ziehe_Gerade = 0 Then _Ziehe_Rahmen()
		EndIf
	EndIf

	If WinActive($GUI_Editor) Then
		If _IsPressed("11", $dll) And _IsPressed("41", $dll) Then ;STRG+A
			_Markiere_alle_controls()
			While _IsPressed("11", $dll) And _IsPressed("41", $dll)
				Sleep(10)
			WEnd
		EndIf


		If _IsPressed("11", $dll) And _IsPressed("5A", $dll) Then ;STRG+Z
		   _Formstudio_Undo()
			While _IsPressed("11", $dll) And _IsPressed("5A", $dll)
				Sleep(10)
			WEnd
		 EndIf

		If _IsPressed("11", $dll) And _IsPressed("59", $dll) Then ;STRG+Y
		   _Formstudio_Redo()
			While _IsPressed("11", $dll) And _IsPressed("59", $dll)
				Sleep(10)
			WEnd
		 EndIf

		 If _IsPressed("09", $dll) Then ;TAB
		   	While _IsPressed("09", $dll) OR _IsPressed("10", $dll)
				Sleep(10)
			WEnd
			Local $CurrentControl = _WinAPI_GetFocus()
		   if $CurrentControl <> 0 then
			  If $Markiertes_Control_ID <> "" Or $Control_Markiert_MULTI = 1 Then _Mini_Editor_Einstellungen_Uebernehmen()
			  Markiere_Control(_WinAPI_GetDlgCtrlID($CurrentControl))
		   Endif
		 EndIf


		If ($Control_Markiert = 1 Or $Control_Markiert_MULTI = 1) Then
			If _IsPressed("43", $dll) Then
				copy_item()
				While _IsPressed("43", $dll)
					Sleep(10)
				WEnd
			EndIf

			;Feintuning bei gedrückter STRG Taste
			If _IsPressed("11", $dll) Then
				$val = 1
			Else
				$val = $Raster
			EndIf

			;Move Control Right
			If _IsPressed("27", $dll) Then
				$Pos_oldpos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
				$Docklabel_X_links = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_X_rechts = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_oben = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_unten = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)

				GUICtrlSetState($Docklabel_X_links, $GUI_HIDE)
				GUICtrlSetState($Docklabel_X_rechts, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_oben, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_unten, $GUI_HIDE)
				_Positionsarray_aller_Controls_aufbauen()

				While (_IsPressed("27", $dll))
					If $Control_Markiert_MULTI = 0 Then
						$pos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
						$Section = ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID)
						If $Markiertes_Control_ID = $TABCONTROL_ID Then $Section = "tab"
						If _IniReadEx($Cache_Datei_Handle, $Section, "locked", 0) = 0 Then
							GUICtrlSetPos($Markiertes_Control_ID, $pos[0] + $val, $pos[1])
							_Pruefe_Ob_Control_an_anderes_andockt_exakt($Markiertes_Control_ID)
						EndIf
						_Aktualisiere_Rahmen()
					Else
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "locked", 0) = 0 Then GUICtrlSetPos($Markierte_Controls_IDs[1], $pos[0] + $val, $pos[1], $pos[2], $pos[3])
						_Aktualisiere_Rahmen_Multi(0, $Markierte_Controls_IDs[1])
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "x", $pos[0])
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "y", $pos[1])
						For $r = 2 To $Markierte_Controls_IDs[0]
							$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
							If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "locked", 0) = 0 Then
								GUICtrlSetPos($Markierte_Controls_IDs[$r], $Pos_w[0] + $val, $Pos_w[1])
								_Aktualisiere_Rahmen_Multi($r - 1, $Markierte_Controls_IDs[$r])
								$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "x", $Pos_w[0])
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "y", $Pos_w[1])
							EndIf
						Next
					EndIf
					Sleep(100)
				WEnd
				If $Control_Markiert_MULTI = 0 Then

					_Update_Control_Cache($Markiertes_Control_ID)
					If $Markiertes_Control_ID = $TABCONTROL_ID Then _Resize_tabcontent($Pos_oldpos[0], $Pos_oldpos[1])
					If _IniReadEx($Cache_Datei_Handle, GUICtrlGetHandle($Markiertes_Control_ID), "type", "") = "group" Then _Resize_groupcontent($Markiertes_Control_ID, $Pos_oldpos[0], $Pos_oldpos[1], $Pos_oldpos[2], $Pos_oldpos[3])
					If $Markiertes_Control_ID = $TABCONTROL_ID Then
						_Lese_MiniEditor($TABCONTROL_ID)
					Else
						_Lese_MiniEditor(ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID))
					EndIf
				Else
					_Mini_Editor_Einstellungen_Multi_Felder_Aktivieren()
				EndIf
				GUICtrlDelete($Docklabel_X_links)
				GUICtrlDelete($Docklabel_X_rechts)
				GUICtrlDelete($Docklabel_Y_oben)
				GUICtrlDelete($Docklabel_Y_unten)
				_Formstudio_UndoRedo_CreateNewSnapshot()
			EndIf

			;Move Control UP
			If _IsPressed("26", $dll) Then
				$Pos_oldpos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
				$Docklabel_X_links = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_X_rechts = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_oben = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_unten = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)

				GUICtrlSetState($Docklabel_X_links, $GUI_HIDE)
				GUICtrlSetState($Docklabel_X_rechts, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_oben, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_unten, $GUI_HIDE)
				_Positionsarray_aller_Controls_aufbauen()

				While (_IsPressed("26", $dll))
					If $Control_Markiert_MULTI = 0 Then
						$pos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
						$Section = ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID)
						If $Markiertes_Control_ID = $TABCONTROL_ID Then $Section = "tab"
						If _IniReadEx($Cache_Datei_Handle, $Section, "locked", 0) = 0 Then
							GUICtrlSetPos($Markiertes_Control_ID, $pos[0], $pos[1] - $val)
							_Pruefe_Ob_Control_an_anderes_andockt_exakt($Markiertes_Control_ID)
						EndIf
						_Aktualisiere_Rahmen()

					Else
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "locked", 0) = 0 Then GUICtrlSetPos($Markierte_Controls_IDs[1], $pos[0], $pos[1] - $val, $pos[2], $pos[3])
						_Aktualisiere_Rahmen_Multi(0, $Markierte_Controls_IDs[1])
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "x", $pos[0])
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "y", $pos[1])
						For $r = 2 To $Markierte_Controls_IDs[0]
							$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
							If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "locked", 0) = 0 Then
								GUICtrlSetPos($Markierte_Controls_IDs[$r], $Pos_w[0], $Pos_w[1] - $val)
								_Aktualisiere_Rahmen_Multi($r - 1, $Markierte_Controls_IDs[$r])
								$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "x", $Pos_w[0])
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "y", $Pos_w[1])
							EndIf
						Next

					EndIf
					Sleep(100)
				WEnd

				If $Control_Markiert_MULTI = 0 Then
					_Update_Control_Cache($Markiertes_Control_ID)
					If $Markiertes_Control_ID = $TABCONTROL_ID Then _Resize_tabcontent($Pos_oldpos[0], $Pos_oldpos[1])
					If _IniReadEx($Cache_Datei_Handle, GUICtrlGetHandle($Markiertes_Control_ID), "type", "") = "group" Then _Resize_groupcontent($Markiertes_Control_ID, $Pos_oldpos[0], $Pos_oldpos[1], $Pos_oldpos[2], $Pos_oldpos[3])
					If $Markiertes_Control_ID = $TABCONTROL_ID Then
						_Lese_MiniEditor($TABCONTROL_ID)
					Else
						_Lese_MiniEditor(ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID))
					EndIf
				Else
					_Mini_Editor_Einstellungen_Multi_Felder_Aktivieren()
				EndIf
				GUICtrlDelete($Docklabel_X_links)
				GUICtrlDelete($Docklabel_X_rechts)
				GUICtrlDelete($Docklabel_Y_oben)
				GUICtrlDelete($Docklabel_Y_unten)
				_Formstudio_UndoRedo_CreateNewSnapshot()
			EndIf

			;Move Control DOWN
			If _IsPressed("28", $dll) Then
				$Pos_oldpos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
				$Docklabel_X_links = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_X_rechts = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_oben = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_unten = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)

				GUICtrlSetState($Docklabel_X_links, $GUI_HIDE)
				GUICtrlSetState($Docklabel_X_rechts, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_oben, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_unten, $GUI_HIDE)
				_Positionsarray_aller_Controls_aufbauen()

				While (_IsPressed("28", $dll))
					If $Control_Markiert_MULTI = 0 Then
						$pos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
						$Section = ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID)
						If $Markiertes_Control_ID = $TABCONTROL_ID Then $Section = "tab"
						If _IniReadEx($Cache_Datei_Handle, $Section, "locked", 0) = 0 Then
							GUICtrlSetPos($Markiertes_Control_ID, $pos[0], $pos[1] + $val)
							_Pruefe_Ob_Control_an_anderes_andockt_exakt($Markiertes_Control_ID)
						EndIf
						_Aktualisiere_Rahmen()
					Else
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "locked", 0) = 0 Then GUICtrlSetPos($Markierte_Controls_IDs[1], $pos[0], $pos[1] + $val, $pos[2], $pos[3])
						_Aktualisiere_Rahmen_Multi(0, $Markierte_Controls_IDs[1])
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "x", $pos[0])
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "y", $pos[1])
						For $r = 2 To $Markierte_Controls_IDs[0]
							$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
							If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "locked", 0) = 0 Then
								GUICtrlSetPos($Markierte_Controls_IDs[$r], $Pos_w[0], $Pos_w[1] + $val)
								_Aktualisiere_Rahmen_Multi($r - 1, $Markierte_Controls_IDs[$r])
								$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "x", $Pos_w[0])
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "y", $Pos_w[1])
							EndIf
						Next
					EndIf
					Sleep(100)
				WEnd
				If $Control_Markiert_MULTI = 0 Then
					_Update_Control_Cache($Markiertes_Control_ID)
					If $Markiertes_Control_ID = $TABCONTROL_ID Then _Resize_tabcontent($Pos_oldpos[0], $Pos_oldpos[1])
					If _IniReadEx($Cache_Datei_Handle, GUICtrlGetHandle($Markiertes_Control_ID), "type", "") = "group" Then _Resize_groupcontent($Markiertes_Control_ID, $Pos_oldpos[0], $Pos_oldpos[1], $Pos_oldpos[2], $Pos_oldpos[3])
					If $Markiertes_Control_ID = $TABCONTROL_ID Then
						_Lese_MiniEditor($TABCONTROL_ID)
					Else
						_Lese_MiniEditor(ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID))
					EndIf
				Else
					_Mini_Editor_Einstellungen_Multi_Felder_Aktivieren()
				EndIf
				GUICtrlDelete($Docklabel_X_links)
				GUICtrlDelete($Docklabel_X_rechts)
				GUICtrlDelete($Docklabel_Y_oben)
				GUICtrlDelete($Docklabel_Y_unten)
				_Formstudio_UndoRedo_CreateNewSnapshot()
			EndIf

			;Move Control Left
			If _IsPressed("25", $dll) Then
				$Pos_oldpos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)

				$Docklabel_X_links = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_X_rechts = GUICtrlCreateLabel("", 10, 10, 1, 9000)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_oben = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)
				$Docklabel_Y_unten = GUICtrlCreateLabel("", 10, 10, 9000, 1)
				GUICtrlSetBkColor(-1, $Farbe_Dockstrich)

				GUICtrlSetState($Docklabel_X_links, $GUI_HIDE)
				GUICtrlSetState($Docklabel_X_rechts, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_oben, $GUI_HIDE)
				GUICtrlSetState($Docklabel_Y_unten, $GUI_HIDE)
				_Positionsarray_aller_Controls_aufbauen()

				While (_IsPressed("25", $dll))
					If $Control_Markiert_MULTI = 0 Then
						$pos = ControlGetPos($GUI_Editor, "", $Markiertes_Control_ID)
						$Section = ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID)
						If $Markiertes_Control_ID = $TABCONTROL_ID Then $Section = "tab"
						If _IniReadEx($Cache_Datei_Handle, $Section, "locked", 0) = 0 Then
							GUICtrlSetPos($Markiertes_Control_ID, $pos[0] - $val, $pos[1])
							_Pruefe_Ob_Control_an_anderes_andockt_exakt($Markiertes_Control_ID)
						EndIf
						_Aktualisiere_Rahmen()
					Else
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "locked", 0) = 0 Then GUICtrlSetPos($Markierte_Controls_IDs[1], $pos[0] - $val, $pos[1], $pos[2], $pos[3])
						_Aktualisiere_Rahmen_Multi(0, $Markierte_Controls_IDs[1])
						$pos = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[1]))
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "x", $pos[0])
						_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[0], "y", $pos[1])
						For $r = 2 To $Markierte_Controls_IDs[0]
							$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
							If _IniReadEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "locked", 0) = 0 Then
								GUICtrlSetPos($Markierte_Controls_IDs[$r], $Pos_w[0] - $val, $Pos_w[1])
								_Aktualisiere_Rahmen_Multi($r - 1, $Markierte_Controls_IDs[$r])
								$Pos_w = ControlGetPos($GUI_Editor, "", GUICtrlGetHandle($Markierte_Controls_IDs[$r]))
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "x", $Pos_w[0])
								_IniWriteEx($Cache_Datei_Handle, $Markierte_Controls_Sections[$r - 1], "y", $Pos_w[1])
							EndIf
						Next
					EndIf
					Sleep(100)
				WEnd
				If $Control_Markiert_MULTI = 0 Then
					_Update_Control_Cache($Markiertes_Control_ID)
					If $Markiertes_Control_ID = $TABCONTROL_ID Then _Resize_tabcontent($Pos_oldpos[0], $Pos_oldpos[1])
					If _IniReadEx($Cache_Datei_Handle, GUICtrlGetHandle($Markiertes_Control_ID), "type", "") = "group" Then _Resize_groupcontent($Markiertes_Control_ID, $Pos_oldpos[0], $Pos_oldpos[1], $Pos_oldpos[2], $Pos_oldpos[3])
					If $Markiertes_Control_ID = $TABCONTROL_ID Then
						_Lese_MiniEditor($TABCONTROL_ID)
					Else
						_Lese_MiniEditor(ControlGetHandle($GUI_Editor, "", $Markiertes_Control_ID))
					EndIf
				Else
					_Mini_Editor_Einstellungen_Multi_Felder_Aktivieren()
				EndIf
				GUICtrlDelete($Docklabel_X_links)
				GUICtrlDelete($Docklabel_X_rechts)
				GUICtrlDelete($Docklabel_Y_oben)
				GUICtrlDelete($Docklabel_Y_unten)
				_Formstudio_UndoRedo_CreateNewSnapshot()
			EndIf

			;Lösche
			If _IsPressed("2E", $dll) Then
				If $Control_Markiert_MULTI = 0 Then
					delete_item()
				Else
					_Delete_Multiitem()
				EndIf
			EndIf

		EndIf
	EndIf
	;V
	If _IsPressed("56", $dll) And WinActive($GUI_Editor) Then
		;Entferne_Makierung()
		paste_item()
		While _IsPressed("56", $dll)
			Sleep(10)
		WEnd
	EndIf

Sleep(10)
WEnd


